#version 330
#extension GL_EXT_gpu_shader4 : enable
//Space Glowing 3Mod01.fsh  by  tholzer
//https://www.shadertoy.com/view/MljyRt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//----------------------------------------------------------------
// SpaceGlowing3.glsl  by Antony Holzer 
//
// A variant of 'Space Glowing 2' seen through a koleidoscope.
// Symmetry defined by Mouse.y position.
// Again ... switch to full screen and lean back!
//
//   v1.0  2017-11-05  initial release
//   v2.0  2017-11-22  variable symmetry 
//
// variantOf: https://www.shadertoy.com/view/ldjBRW
// see also:  https://www.shadertoy.com/view/Mlj3zW
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// tags:      3d, antialiasing, space, raytrace, glowing, satiny
//----------------------------------------------------------------

vec3 rotateY(vec3 p, float angle)
{
  float sa = sin(angle),   ca = cos(angle);
  return vec3(ca * p.x + sa * p.z, p.y, -sa * p.x + ca * p.z);
}

//----------------------------------------------------------------
float map (in vec3 p) 
{
	vec3 c = p; 
    float res = 0.0;
	for (int i=0; i < 4; i++) 
	{
		p = abs(p) / dot(p,p) -0.7;
		p.yz = vec2(p.y*p.y-p.z*p.z, 2.*p.y*p.z);
		res += exp(-20.0 * abs(dot(p,c)));
	}
	return res * 0.4;
}

//----------------------------------------------------------------
vec3 raymarch (vec3 ro, vec3 rd)
{
	float t = 5.0;
    float c = 0.0;
	vec3 col = vec3(0.0); 
	for (int i=0; i < 6; i++)
	{
		t += exp(c * -2.0) * 0.02;
		c = map(t * rd + ro);               
		col= vec3(22.0*c*c, 2.0*c, 6.0*c*c*c) *0.16 + col *0.6;
		c = map(t*0.99 * rd + ro);               
		col+= vec3(4.0*c*c, 22.0*c*c, c) *0.16 + col *0.6;
		c = map(t*1.01 * rd + ro);               
		col+= vec3(4.0*c*c, 8.0*c*c, 11.*c)*0.16 + col *0.6;
         // blue
//		col= vec3(c*c, c, 6.0*c*c*c) *0.16 + col *0.96;
		col= vec3(8.0*c*c*c, 2.0*c*c, 8.0*c) *0.16 + col *0.96;
		col= vec3(c, 18.0*c*c*c, 8.0*c*c)*0.16 + col *0.96;
		
	}
	return col*0.2;
}

//----------------------------------------------------------------

const float PI = 3.14159265359;

//float sideCount = 1.0;  // min. number of sides

//----------------------------------------------------------------
// equal to koleidoscope, but more compact 
//----------------------------------------------------------------
void smallKoleidoscope(inout vec2 uv, float ka)
{
  float angle = abs (mod (atan (uv.x, uv.y), 2.0 * ka) - ka) + 0.01*iTime;
  uv = length(uv) * vec2(cos(angle), sin(angle));
}

//----------------------------------------------------------------
void main (void)
//void mainImage (out vec4 fragColor, in vec2 fragCoord)
{
    vec2 p = 2.0*(gl_FragCoord.xy - iResolution.xy*0.5) / iResolution.y;
    vec2 mp = iMouse.xy / iResolution.xy;
        
    float sideCount = 1.0 + round(mp.y * 11.0);
    
    smallKoleidoscope(p, PI / sideCount);    
    
    vec3 ro = rotateY(vec3(3.), iTime*0.2 + iMouse.x / iResolution.x);
    vec3 uu = normalize(cross(ro, vec3(1.0, 0.0, 0.0)));
    vec3 vv = normalize(cross(uu, ro));
    vec3 rd = normalize(p.x*uu + p.y*vv - ro*0.5);
    gl_FragColor.rgb = log(raymarch(ro,rd) + 1.0)*0.5;
    gl_FragColor.a = 1.0;
}
